# A Fast and Provable Algorithm for Sparse Phase Retrieval (MATLAB Package)

This MATLAB package provides implementations of a fast second-order algorithm based on Newton projection for sparse phase retrieval. The licensing information is available in LICENSE.txt file.

The algorithm consists of two stages:

1. Initialization: The first stage generates an initial estimate that is close to the ground truth signal, using the sparse spectral initialization method proposed in [1].

2. Refinement: The second stage refines the initial estimate to obtain the ground truth signal, using our proposed algorithm.


Getting Started

To run the code, follow these steps:
(1) Download the source files.
(2) Run 'demo.m' in MATLAB.


Reference 
[1] Gauri Jagatap and Chinmay Hegde, "Sample-Efficient Algorithms for Recovering Structured Signals From Magnitude-Only Measurements," in IEEE Transactions on Information Theory, vol. 65, no. 7, pp. 4434-4456, July 2019.


